import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Route, RouteComponentProps } from 'react-router';

import { fullWidthOutlineDecorator, routerDecorator, toastsSupportDecorator } from '../../../stories';
import { Scenario } from './Scenario';

storiesOf('scenarios|item', module)
   .addDecorator(fullWidthOutlineDecorator)
   .addDecorator(toastsSupportDecorator)
   .addDecorator(routerDecorator)
   .add('regular', () => {
      const render = (props: RouteComponentProps<{ id: string }>) => {
         props.match.params.id = '16';

         return <Scenario {...(props as any)} />;
      };

      return <Route render={render} />;
   });
