import { Loader, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext, useMemo } from 'react';
import { RouteComponentProps } from 'react-router';

import { ScenarioContext } from '../../../../shared';
import { AuditLog, ILogFilters, ILogUrlParams } from '../../../AuditLog';

export const ScenarioAuditLog = React.memo((props: RouteComponentProps<ILogUrlParams>) => {
   const context = useContext(ScenarioContext);
   const scenario = context.scenario;
   if (!scenario) {
      return <Loader />;
   }

   // eslint-disable-next-line react-hooks/rules-of-hooks
   const forceFilters = useMemo(
      () => ({ scenario_id: new Set([scenario.scenario_id.toString()]) } as Partial<ILogFilters>),
      [scenario.scenario_id],
   );

   return (
      <>
         <WindowTitle value={`Scenario ${scenario.name} audit log`} />

         <AuditLog layout={'all'} forceFilters={forceFilters} {...props} />
      </>
   );
});

ScenarioAuditLog.displayName = 'ScenarioAuditLog';
