import { Loader } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext } from 'react';
import { useTitle } from 'react-use';

import { ScenarioContext } from '../../../../shared';

import { ScenarioJsonDetails } from '../../components/ScenarioJsonDetails/ScenarioJsonDetails';

export const ScenarioDetails = React.memo(() => {
   const context = useContext(ScenarioContext);

   const scenario = context.scenario;

   useTitle(`Scenario ${scenario?.name ?? ''} details`);

   if (!scenario) {
      return <Loader />;
   }

   return <ScenarioJsonDetails short={false} value={scenario} />;
});

ScenarioDetails.displayName = 'ScenarioDetails';
