import { Loader, styleHelpers } from '@yandex-infracloud-ui/libs-next';
import { WarnIcon } from 'design/icons';
import * as React from 'react';
import { useContext, useMemo } from 'react';
import { RouteComponentProps } from 'react-router';
import { Link } from 'react-router-dom';
import { useLocation } from 'react-use';
import { IHost, ROUTE_LINKS } from '../../../../models';
import { HostListRich } from '../../../../rich_shared/host_list';
import { HostListContext, ScenarioContext } from '../../../../shared';
import { OperationStatus, OperationStatusType } from '../../components/OperationStatus/OperationStatus';

import styles from './ScenarioHostList.module.css';

export const ScenarioHostList = React.memo((props: RouteComponentProps) => {
   const location = useLocation();
   const context = useContext(ScenarioContext);

   const scenario = context.scenario;
   if (!scenario) {
      return <Loader />;
   }

   const hosts = useMemo(() => scenario.hosts ?? [], [scenario.hosts]); // eslint-disable-line react-hooks/rules-of-hooks
   const invs = useMemo(() => new Set(hosts.map(host => host.inv)), [hosts]); // eslint-disable-line react-hooks/rules-of-hooks

   // eslint-disable-next-line react-hooks/rules-of-hooks
   const contextValue = useMemo(
      () => ({
         additionalColumns: [
            {
               order: 1,
               render: (host: IHost) => {
                  const status =
                     scenario.status === OperationStatusType.Finished
                        ? OperationStatusType.Finished
                        : hosts.find(h => h.inv === host.inv)!.status;

                  return <OperationStatus status={status} />;
               },
               title: 'Action status',
            },
            {
               order: 12,
               render: (host: IHost) =>
                  host.scenario_id && host.scenario_id !== scenario.scenario_id ? (
                     <>
                        <WarnIcon className={styles.icon} />

                        <span>
                           Host is used in another scenario{' '}
                           <Link
                              to={{
                                 pathname: ROUTE_LINKS.scenario(host.scenario_id),
                                 state: { prev: location },
                              }}
                           >
                              #{host.scenario_id}
                           </Link>
                        </span>
                     </>
                  ) : null,
               title: '',
            },
         ],
         hideProjectColumn: false,
      }),
      [location, hosts, scenario.scenario_id, scenario.status],
   );

   return (
      <HostListContext.Provider value={contextValue}>
         {invs.size === 0 ? (
            <div className={styleHelpers.center}>No data</div>
         ) : (
            <HostListRich {...props} forceIds={invs} />
         )}
      </HostListContext.Provider>
   );
});

ScenarioHostList.displayName = 'ScenarioHostList';
