import * as React from 'react';
import styles from './ScenarioStages.module.css';
import { ScenarioStagesTableItem } from './ScenarioStagesTableItem';

export const ScenarioStagesTable = (props: { scenarioState: any; stages: any }) => {
   const { stages } = props;

   return (
      <table className={styles.table} style={{ maxWidth: 1000, marginTop: 20 }}>
         <thead>
            <tr>
               <th key={'name'}>Stage name</th>
               <th key={'state'}>State</th>
               <th key={'description'}>Description</th>
            </tr>
         </thead>
         <tbody>
            {stages.map((item: any, index: any) => {
               return (
                  <ScenarioStagesTableItem
                     key={item.uid}
                     name={item.name}
                     status={item.status as any}
                     stage={item}
                     level={0}
                  />
               );
            })}
         </tbody>
      </table>
   );
};

ScenarioStagesTable.displayName = 'ScenarioStagesTable';
