import { PropsWithChildren } from 'react';
import * as React from 'react';

import styles from './Sidebar.module.css';

interface Props {
   onClose: () => void;
}

export const Sidebar = (props: PropsWithChildren<Props>) => {
   return (
      <div className={styles.veil} onClick={props.onClose}>
         <div
            className={styles.sidebar}
            onClick={e => {
               e.stopPropagation();
            }}
         >
            {props.children}
         </div>
      </div>
   );
};

Sidebar.displayName = 'Sidebar';
