import { json } from '@yandex-infracloud-ui/libs-next';
import { Collapse } from '@yandex-data-ui/common';
import React from 'react';

import { Field } from '../../../../shared';

interface IStageHostInfoItemProps {
   description: string;
   msg: string;
   status: string;
   stage: any;
}

export const StageHostInfoItem: React.FC<IStageHostInfoItemProps> = ({ description, msg, stage, status }) => {
   return (
      <div style={{ padding: '0 20px 20px' }}>
         {description && <Field title={'Description'}>{description}</Field>}
         {msg && <Field title={'Message'}>{msg}</Field>}
         {status && <Field title={'Status'}>{status}</Field>}
         <Collapse
            arrowPosition={'right'}
            arrowView={'icon'}
            contentMarginTop={12}
            title={'JSON'}
            titleSize={'m'}
            isSecondary={true}
         >
            <pre>{json(stage)}</pre>
         </Collapse>
      </div>
   );
};
