import { classNames } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { Link } from 'react-router-dom';
import { ROUTE_LINKS, ScenarioStageStatus } from '../../../../models';
import { OPERATION_STATUS_ICONS } from '../../components/OperationStatus/OperationStatus';
import styles from './ScenarioStages.module.css';

interface IItemProps {
   msg?: any;
   level: number;
   name: string;
   status: ScenarioStageStatus;
}

export const StageHostTableItem = React.memo(({ name, status, msg, level }: IItemProps) => {
   // render
   return (
      <tr
         className={classNames(styles.row, {
            [styles.expanded]: false,
         })}
      >
         <td className={styles.nowrap}>
            <div style={{ paddingLeft: level * 12 }}>
               {OPERATION_STATUS_ICONS.get(status as any)}
               <Link
                  to={{
                     pathname: ROUTE_LINKS.host(name),
                  }}
               >
                  {name}
               </Link>
            </div>
         </td>
         <td className={classNames(styles.nowrap, styles.description)} colSpan={2} title={msg}>
            {msg}
         </td>
      </tr>
   );
});

StageHostTableItem.displayName = 'StageHostTableItem';
