import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import { default as React } from 'react';

import { IScenario } from '../../../models';
import {
   modalsSupportDecorator,
   routerDecorator,
   toastsSupportDecorator,
   userSwitcherDecorator,
} from '../../../stories';

import { OperationStatusType } from '../components/OperationStatus/OperationStatus';
import { ScenarioType, ScheduleType } from '../models';
import { ScenarioItem } from './ScenarioItem';

const item1: IScenario = {
   action_time: 1586192924,
   creation_time: 1569429192,
   hosts: [
      {
         inv: 900181673,
         status: OperationStatusType.Done,
      },
   ],
   issuer: 'khoden@',
   labels: {},
   name: 'noop',
   scenario_id: 6,
   scenario_type: ScenarioType.HostsTransfer,
   schedule_type: ScheduleType.All,
   status: OperationStatusType.Created,
   workStatus: OperationStatusType.Created,
   ticket_key: '',
};

const item2: IScenario = { ...item1, status: OperationStatusType.Started };

const item3: IScenario = { ...item1, status: OperationStatusType.Finished };

function RegularStory() {
   return (
      <table style={{ width: '100%' }}>
         <ScenarioItem item={item1} onCanceled={action('cancel')} />
         <ScenarioItem item={item2} onCanceled={action('cancel')} />
         <ScenarioItem item={item3} onCanceled={action('cancel')} />
      </table>
   );
}

storiesOf('scenarios|_list/ScenarioItem', module)
   .addDecorator(routerDecorator)
   .addDecorator(modalsSupportDecorator)
   .addDecorator(userSwitcherDecorator)
   .addDecorator(toastsSupportDecorator)
   .add('regular', () => <RegularStory />);
