import { storiesOf } from '@storybook/react';
import { default as React } from 'react';
import { routerDecorator } from '../../../../stories';
import { OperationStatus, OperationStatusType } from './OperationStatus';

function OperationStatusStory() {
   return (
      <>
         {Object.values(OperationStatusType).map(status => (
            <div key={status}>
               <OperationStatus status={status} />
            </div>
         ))}

         <div>
            <OperationStatus status={'unknown' as any} />
         </div>
      </>
   );
}

storiesOf('scenarios|components/OperationStatus', module)
   .addDecorator(routerDecorator)
   .add('regular', () => <OperationStatusStory />);
