import { classNames } from '@yandex-infracloud-ui/libs-next';
import {
   CircleIcon,
   CloseIcon,
   CubeIcon,
   DoneIcon,
   FinishedIcon,
   PauseIcon,
   StartedIcon,
   WaitingIcon,
} from 'design/icons';
import * as React from 'react';
import { ReactNode } from 'react';

import classes from './OperationStatus.module.css';

export enum OperationStatusType {
   Approvement = 'approvement',
   Canceled = 'canceled',
   Canceling = 'canceling',
   Rejected = 'rejected',
   Created = 'created',
   Done = 'done',
   Finished = 'finished',
   Finishing = 'finishing',
   Paused = 'paused',
   Processing = 'processing',
   Queue = 'queue',
   Ready = 'ready',
   Started = 'started',
   Group = 'group',
}

/* tslint:disable:jsx-key */
const icons = new Map<OperationStatusType, ReactNode>([
   [
      OperationStatusType.Canceled,
      <CloseIcon fixedWidth={true} className={classNames(classes.faIcon, classes.canceled)} />,
   ],
   [OperationStatusType.Created, <DoneIcon className={classNames(classes.faIcon, classes.positive)} />],
   [OperationStatusType.Done, <DoneIcon className={classNames(classes.faIcon, classes.positive)} />],
   [OperationStatusType.Finished, <FinishedIcon className={classNames(classes.faIcon, classes.positive)} />],
   [OperationStatusType.Paused, <PauseIcon fixedWidth={true} className={classNames(classes.faIcon, classes.paused)} />],
   [
      OperationStatusType.Processing,
      <CircleIcon fixedWidth={true} className={classNames(classes.faIcon, classes.processing)} />,
   ],
   [OperationStatusType.Queue, <WaitingIcon className={classNames(classes.faIcon, classes.paused)} />],
   [OperationStatusType.Ready, <DoneIcon className={classNames(classes.faIcon, classes.positive)} />],
   [OperationStatusType.Started, <StartedIcon className={classNames(classes.faIcon, classes.positive)} />],
   [OperationStatusType.Group, <CubeIcon fixedWidth={true} className={classNames(classes.faIcon, classes.group)} />],
]);

/* tslint:enable:jsx-key */

interface IProps {
   status: OperationStatusType;
}

export const OPERATION_STATUS_ICONS = icons;

export const OperationStatus = ({ status }: IProps) => (
   <span className={classes.wrapper}>
      {icons.get(status) ?? null}
      {status}
   </span>
);
