import { formatDate } from '@yandex-infracloud-ui/libs-next';
import React from 'react';

import { ScenarioErrors } from '../../../../models';
import { TextMessage } from '../../../../shared';

interface Props {
   className?: string;
   errors: ScenarioErrors;
}

export const ScenarioErrorMessages: React.FC<Props> = React.memo(({ className, errors }) => (
   <div className={className}>
      {Object.values(errors).map((m, i) => (
         <TextMessage
            key={i}
            isError={true}
            title={m.exc_info?.timestamp ? formatDate(new Date(m.exc_info.timestamp)) : undefined}
            text={(m.exc_info?.host_name ? `${m.exc_info.host_name}: ` : '') + m.exc_info?.error_message ?? m.id}
         />
      ))}
   </div>
));

ScenarioErrorMessages.displayName = 'ScenarioErrorMessages';
