import { classNames, isEmpty, Json } from '@yandex-infracloud-ui/libs-next';
import { Collapse } from '@yandex-data-ui/common';
import * as React from 'react';

import { IScenario } from '../../../../models';
import { ScenarioErrorMessages } from '../ScenarioErrorMessages/ScenarioErrorMessages';

import classes from './ScenarioJsonDetails.module.css';

interface DetailsProps {
   rest?: any;
   short?: boolean;
   value: IScenario;
}

interface Props {
   short: boolean;
   value: IScenario;
}

interface SectionProps {
   className?: string;
   label: string;
   obj: any;
   dafaultIsExpand?: boolean;
}

const JsonSectionCollapse = ({ label, obj, className, dafaultIsExpand = true }: SectionProps) => (
   <Collapse
      className={className}
      arrowPosition={'right'}
      arrowView={'icon'}
      contentMarginTop={12}
      title={label}
      titleSize={'s'}
      dafaultIsExpand={dafaultIsExpand}
   >
      <Json obj={obj} />
   </Collapse>
);

const JsonSection = ({ label, obj, className }: SectionProps) => (
   <section className={className}>
      <h4>{label}</h4>
      <Json obj={obj} />
   </section>
);

const DefaultDetails = ({ value, rest, short }: DetailsProps) => (
   <>
      {isEmpty(value.errors) ? null : short ? (
         <ScenarioErrorMessages className={classes.errors} errors={value.errors} />
      ) : (
         <JsonSection className={classes.errors} label={'Errors'} obj={value.errors} />
      )}

      <JsonSection className={classes.labels} label={'Labels'} obj={value.labels} />

      <JsonSection className={classes.scriptArguments} label={'Script arguments'} obj={value.script_args} />

      {short ? null : (
         <JsonSectionCollapse
            className={classes.dataStorage}
            label={'Data Storage'}
            obj={value.data_storage}
            dafaultIsExpand={false}
         />
      )}

      {short ? null : <JsonSection className={classes.hosts} label={'Hosts'} obj={value.hosts} />}

      {short ? null : <JsonSectionCollapse className={classes.other} label={'Other parameters'} obj={rest} />}
   </>
);

export const ScenarioJsonDetails = ({ short, value }: Props) => {
   const { hosts, labels, script_args, errors, data_storage, ...rest } = value;

   return (
      <div className={classNames(classes.json, { [classes.short]: short })}>
         <DefaultDetails value={value} rest={rest} short={short} />
      </div>
   );
};

ScenarioJsonDetails.displayName = 'ScenarioJsonDetails';
