import { DISMISS_REASON, FormFieldType, FormLayout, IFormField, useDismounted } from '@yandex-infracloud-ui/libs-next';
import { IModalProps, ModalLayout, toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';
import { takeUntil } from 'rxjs/operators';
import { IScenario, IScenarioFinishParams } from '../../../../../models';
import { scenariosApi } from '../../../../../services';

interface Props extends IModalProps<IScenarioFinishParams> {
   item: IScenario;
}

const fields: IFormField<IScenarioFinishParams>[] = [
   {
      label: 'Reason',
      name: 'reason',
      placeholder: 'Reason (optional)',
      type: FormFieldType.Text,
   },
];

export const FinishScenarioModal = React.memo(({ item, ok, cancel }: Props) => {
   // hooks
   const dismounted = useDismounted();
   const [value, setValue] = useState<IScenarioFinishParams>({
      reason: '',
   });

   // handlers
   const onOk = useCallback(() => {
      scenariosApi
         .finish(item.scenario_id, value)
         .pipe(takeUntil(dismounted))
         .subscribe(() => ok(value), toasts.handleApiError('Finish scenario'));
   }, [dismounted, item.scenario_id, ok, value]);

   const onCancel = useCallback(() => cancel(DISMISS_REASON), [cancel]);
   const updateParams = useCallback((e: SyntheticEvent | null, v: IScenarioFinishParams) => setValue(v), []);

   // render
   return (
      <ModalLayout title={'Finish scenario'} onOk={onOk} onDismiss={onCancel}>
         <FormLayout onChange={updateParams} value={value} fields={fields} />
      </ModalLayout>
   );
});

FinishScenarioModal.displayName = 'FinishScenarioModal';
