import * as React from 'react';
import { DISMISS_REASON, FormFieldType, FormLayout, IFormField, useDismounted } from '@yandex-infracloud-ui/libs-next';
import { IModalProps, ModalLayout, toasts } from '@yandex-infracloud-ui/libs';
import { IScenarioPauseParams, IScenario } from '../../../../../models';
import { SyntheticEvent, useCallback, useState } from 'react';
import { scenariosApi } from '../../../../../services';
import { takeUntil } from 'rxjs/operators';

interface Props extends IModalProps<IScenarioPauseParams> {
   item: IScenario;
}

const fields: IFormField<IScenarioPauseParams>[] = [
   {
      label: 'Reason',
      name: 'reason',
      placeholder: 'Reason (optional)',
      type: FormFieldType.Text,
   },
];

export const PauseScenarioModal = React.memo(({ item, ok, cancel }: Props) => {
   // hooks
   const dismounted = useDismounted();
   const [value, setValue] = useState<IScenarioPauseParams>({
      reason: '',
   });

   // handlers
   const onOk = useCallback(() => {
      scenariosApi
         .pause(item.scenario_id, value)
         .pipe(takeUntil(dismounted))
         .subscribe(() => ok(value), toasts.handleApiError('Pause scenario'));
   }, [dismounted, item.scenario_id, ok, value]);

   const onCancel = useCallback(() => cancel(DISMISS_REASON), [cancel]);
   const updateParams = useCallback((e: SyntheticEvent | null, v: IScenarioPauseParams) => setValue(v), []);

   // render
   return (
      <ModalLayout title={'Pause scenario'} onOk={onOk} onDismiss={onCancel}>
         <FormLayout onChange={updateParams} value={value} fields={fields} />
      </ModalLayout>
   );
});

PauseScenarioModal.displayName = 'PauseScenarioModal';
