import * as React from 'react';
import { DISMISS_REASON, FormFieldType, FormLayout, IFormField, useDismounted } from '@yandex-infracloud-ui/libs-next';
import { IModalProps, ModalLayout, toasts } from '@yandex-infracloud-ui/libs';
import { IScenarioSkipParams, IScenario } from '../../../../../models';
import { SyntheticEvent, useCallback, useState } from 'react';
import { scenariosApi } from '../../../../../services';
import { takeUntil } from 'rxjs/operators';

interface Props extends IModalProps<IScenarioSkipParams> {
   item: IScenario;
}

const fields: IFormField<IScenarioSkipParams>[] = [
   {
      label: 'Reason',
      name: 'reason',
      placeholder: 'Reason',
      type: FormFieldType.Text,
   },
];

export const SkipScenarioModal = React.memo(({ item, ok, cancel }: Props) => {
   // hooks
   const dismounted = useDismounted();
   const [value, setValue] = useState<IScenarioSkipParams>({
      reason: '',
   });

   // handlers
   const onOk = useCallback(() => {
      scenariosApi
         .skip(item.scenario_id, value)
         .pipe(takeUntil(dismounted))
         .subscribe(() => ok(value), toasts.handleApiError('Skip pause scenario'));
   }, [dismounted, item.scenario_id, ok, value]);

   const onCancel = useCallback(() => cancel(DISMISS_REASON), [cancel]);
   const updateParams = useCallback((e: SyntheticEvent | null, v: IScenarioSkipParams) => setValue(v), []);

   // render
   return (
      <ModalLayout title={'Skip pause scenario'} onOk={onOk} onDismiss={onCancel}>
         <FormLayout onChange={updateParams} value={value} fields={fields} />
      </ModalLayout>
   );
});

SkipScenarioModal.displayName = 'SkipScenarioModal';
