import { DISMISS_REASON, FormFieldType, FormLayout, IFormField, useDismounted } from '@yandex-infracloud-ui/libs-next';
import { IModalProps, ModalLayout, toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';
import { takeUntil } from 'rxjs/operators';
import { IScenario, IScenarioStartParams } from '../../../../../models';
import { scenariosApi } from '../../../../../services';

interface Props extends IModalProps<IScenarioStartParams> {
   item: IScenario;
}

const fields: IFormField<IScenarioStartParams>[] = [
   {
      label: 'Reason',
      name: 'reason',
      placeholder: 'Reason (optional)',
      type: FormFieldType.Text,
   },
];

export const StartScenarioModal = React.memo(({ item, ok, cancel }: Props) => {
   // hooks
   const dismounted = useDismounted();
   const [value, setValue] = useState<IScenarioStartParams>({
      reason: '',
   });

   // handlers
   const onOk = useCallback(() => {
      const request = scenariosApi.start(item.scenario_id, value);
      request.pipe(takeUntil(dismounted)).subscribe(() => ok(value), toasts.handleApiError('Start scenario'));
   }, [dismounted, item.scenario_id, ok, value]);

   const onCancel = useCallback(() => cancel(DISMISS_REASON), [cancel]);
   const updateParams = useCallback((e: SyntheticEvent | null, v: IScenarioStartParams) => setValue(v), []);

   // render
   return (
      <ModalLayout title={'Start scenario'} onOk={onOk} onDismiss={onCancel}>
         <FormLayout onChange={updateParams} value={value} fields={fields} />
      </ModalLayout>
   );
});

StartScenarioModal.displayName = 'StartScenarioModal';
