import { takeUntil } from 'rxjs/operators';
import { useCallback } from 'react';
import { useDismounted, modalService } from '@yandex-infracloud-ui/libs';

export function useOpenModal<T>() {
   const dismounted = useDismounted();

   const openModal = useCallback(
      (component: any, props: T, callback?: (resp: any) => void, closeOnOutsideClick?: boolean) => {
         modalService
            .open(component, { ...props }, closeOnOutsideClick)
            .pipe(takeUntil(dismounted))
            .subscribe(resp => (callback ? callback(resp) : null));
      },
      [dismounted],
   );

   return {
      openModal,
   };
}
