import React, { SyntheticEvent } from 'react';
import {
   FieldLayout2,
   ExtendedFieldConfig,
   useExtendedField,
   DateTimePicker,
   fromTimestamp,
} from '@yandex-infracloud-ui/libs-next';
import { useCallback } from 'react';

export const DateTimeField: React.FC<ExtendedFieldConfig> = props => {
   // hooks
   const { onChange, disabled, readonly } = useExtendedField(props);

   // handlers
   const handleDateChange = useCallback((e: SyntheticEvent, v: Date) => onChange(Math.floor(v.getTime() / 1000)), [
      onChange,
   ]);

   // render
   return (
      <FieldLayout2 {...props}>
         <DateTimePicker
            showTimeString={true}
            withTime={true}
            value={fromTimestamp(props.value) || null}
            onChange={handleDateChange}
            disabled={disabled || readonly}
         />
      </FieldLayout2>
   );
};

DateTimeField.displayName = 'DateTimeField';
