import { DeclarativeFields, ExtendedFieldConfig } from '@yandex-infracloud-ui/libs-next';
import { Form, useFormikContext } from 'formik';
import * as React from 'react';
import { scriptArgsFields } from './formFields';
import styles from './ScenarioArgsField.module.css';

export const ScenarioArgsField: React.FC<ExtendedFieldConfig> = () => {
   const context = useFormikContext();
   const values = context.values as ExtendedFieldConfig<any, any>;
   const fields = scriptArgsFields[values.scenario_type] || [];

   if (fields.length === 0) {
      return null;
   }

   return (
      <div className={styles.fullWidth}>
         <Form>
            <DeclarativeFields configs={fields} />
         </Form>
      </div>
   );
};

ScenarioArgsField.displayName = 'ScenarioArgsField';
