import * as React from 'react';
import { FieldLayout2, ExtendedFieldConfig, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import { TextInputWithCounter } from '../../../../shared';
import styles from './ScenarioNameField.module.css';

// TODO добавить подобное поле прямо в библиотеку
export const ScenarioNameField: React.FC<ExtendedFieldConfig> = props => {
   const { disabled, onChange } = useExtendedField(props);

   return (
      <FieldLayout2 {...props}>
         <TextInputWithCounter
            cls={styles.control}
            text={props.value}
            placeholder={props.placeholder}
            disabled={disabled}
            onUpdate={onChange}
            maxLength={100}
         />
      </FieldLayout2>
   );
};

ScenarioNameField.displayName = 'ScenarioNameField';
