import * as React from 'react';
import { FieldLayout2, ExtendedFieldConfig, useExtendedField } from '@yandex-infracloud-ui/libs-next';
import { ScenarioType } from '../../models';
import { YCSelect } from '@yandex-data-ui/common';
import { useCallback, useMemo } from 'react';
import { arrayToYCSelectItem } from 'utils/toLibs';

import classes from './ScenarioTypeField.module.css';

export const ScenarioTypeField: React.FC<ExtendedFieldConfig> = props => {
   // hooks
   const { onChange } = useExtendedField(props);
   const items = useMemo(() => arrayToYCSelectItem(Object.values(ScenarioType)), []);

   // handlers
   const onSelect = useCallback(
      v => {
         onChange(v);
      },
      [onChange],
   );

   // render
   return (
      <FieldLayout2 {...props}>
         <YCSelect
            onUpdate={onSelect}
            className={classes.select}
            value={props.value}
            items={items}
            placeholder={'Select automation plot'}
            showSearch={false}
         />
      </FieldLayout2>
   );
};

ScenarioTypeField.displayName = 'ScenarioTypeField';
