import { ExtendedFieldConfig } from '@yandex-infracloud-ui/libs-next';
import { addBusinessDays } from 'date-fns';
import { ScenarioType } from '../../models';

type ScriptArgsFieldsStore = {
   [type in ScenarioType]: ExtendedFieldConfig<any>[];
};

export const scriptArgsFields: ScriptArgsFieldsStore = {
   [ScenarioType.ITDCMaintenance]: [],
   [ScenarioType.HostsTransfer]: [],
   [ScenarioType.ReservedHostsTransfer]: [],
   [ScenarioType.NOCHard]: [],
   [ScenarioType.NOCSoft]: [],
   // Save as example
   // [ScenarioType.Maintenance]: [
   //    {
   //       as: InputField2,
   //       label: 'Switch',
   //       name: 'switch',
   //    },
   //    {
   //       as: InputField2,
   //       controlProps: {
   //          type: 'number',
   //       },
   //       label: 'Timeout',
   //       name: 'timeout',
   //    },
   // ],
};

export const getMaintenceTimeValue = (
   name: 'maintenance_start_time' | 'maintenance_end_time',
   value: any,
): number | undefined => {
   const startDate = new Date();
   startDate.setHours(11, 0, 0, 0);

   const endDate = new Date();
   endDate.setHours(12, 0, 0, 0);

   switch (value) {
      case 'start':
         return name === 'maintenance_start_time'
            ? Math.floor(addBusinessDays(startDate, 1).getTime() / 1000)
            : undefined;

      case 'range':
         return name === 'maintenance_start_time'
            ? Math.floor(addBusinessDays(startDate, 1).getTime() / 1000)
            : Math.floor(addBusinessDays(endDate, 1).getTime() / 1000);

      case 'disabled':
      default:
         return undefined;
   }
};
