import { setAsArray } from '@yandex-infracloud-ui/libs-next';
import { boolean, number, object, string } from 'yup';
import { OperationStatusType } from './components/OperationStatus/OperationStatus';

export enum IssuerFilterType {
   My = 'my',
   All = 'all',
}

export enum ScenarioType {
   HostsTransfer = 'hosts-transfer',
   ReservedHostsTransfer = 'reserved-hosts-transfer',
   ITDCMaintenance = 'itdc-maintenance',
   NOCHard = 'noc-hard',
   NOCSoft = 'noc-soft',
}

export enum ScheduleType {
   All = 'all',
   Rack = 'rack',
}

export type HostStatus = OperationStatusType.Done | OperationStatusType.Queue | OperationStatusType.Processing;
export type ScenarioStatus =
   | OperationStatusType.Canceled
   | OperationStatusType.Created
   | OperationStatusType.Finished
   | OperationStatusType.Paused
   | OperationStatusType.Ready
   | OperationStatusType.Started;

export type ScenarioWorkStatus =
   | OperationStatusType.Created
   | OperationStatusType.Started
   | OperationStatusType.Ready
   | OperationStatusType.Approvement
   | OperationStatusType.Rejected
   | OperationStatusType.Finishing
   | OperationStatusType.Finished
   | OperationStatusType.Canceling
   | OperationStatusType.Canceled;

export interface Labels {
   [key: string]: string;
}

export interface IScenarioWaitArgs {
   responsible?: string;
   target_project_id?: string;
}

export interface IScenarioMaintenanceTimeArgs {
   maintenance_start_time?: number;
   maintenance_end_time?: number;
}

export interface IScenarioHostsTransferArgs {
   delete?: boolean;
   abc_project_id?: string;
   target_project_id: string;
}

export interface IScenarioMaintenanceArgs {
   switch?: string;
   timeout?: number;
}

export type ScenarioScriptArgs =
   | IScenarioWaitArgs
   | IScenarioMaintenanceArgs
   | IScenarioHostsTransferArgs
   | IScenarioMaintenanceTimeArgs;

// Add hosts to RTC form
const hostsTransferScenarioShape = {
   ticket_key: string().required().nullable(),
   name: string().required(),
   hosts: setAsArray().of(string()),
   _transferType: string().required(),
   script_args: object({
      target_project_id: string().when('delete', {
         is: false,
         then: string().required().nullable(),
      }),
      abc_service_id: number().nullable(),
      delete: boolean().required(),
   }),
   // labels: TODO add validation
};

export const hostsTransferScenarioSchema = object().shape(hostsTransferScenarioShape);

const reservedHostsTransferScenarioShape = {
   ticket_key: string().required().nullable(),
   name: string().required(),
   hosts: setAsArray().of(string()),
   script_args: object({
      target_project_id: string().when('delete', {
         is: false,
         then: string().required().nullable(),
      }),
      delete: boolean().required(),
   }),
   // labels: TODO add validation
};

export const reservedHostsTransferScenarioSchema = object().shape(reservedHostsTransferScenarioShape);

// ITDC Maintenance scenario form
const itdcMaintenanceScenarioShape = {
   ticket_key: string().required().nullable(),
   name: string().required(),
   _resourceType: string().required(),
   hosts: setAsArray().of(string()),
   script_args: object({
      rack: string().nullable(),
      maintenance_start_time: number().nullable(),
      maintenance_end_time: number().nullable(),
   }),
};

export const itdcMaintenanceScenarioSchema = object().shape(itdcMaintenanceScenarioShape);

// NOC-hard scenario form
const nocHardScenarioShape = {
   ticket_key: string().required().nullable(),
   name: string().required(),
   hosts: setAsArray().of(string()),
   script_args: object({
      switch: string().nullable(),
      maintenance_start_time: number().nullable(),
      maintenance_end_time: number().nullable(),
   }),
};

export const nocHardScenarioSchema = object().shape(nocHardScenarioShape);

// NOC-soft scenario form
const nocSoftcenarioShape = {
   ticket_key: string().required().nullable(),
   name: string().required(),
   script_args: object({
      switch: string().required().nullable(),
   }),
};

export const nocSoftScenarioSchema = object().shape(nocSoftcenarioShape);
