import { AppRoute } from '@yandex-infracloud-ui/libs-next';
import { ScenarioAuditLog } from './Scenario/audit_log/ScenarioAuditLog';
import { ScenarioDetails } from './Scenario/details/ScenarioDetails';
import { ScenarioHostList } from './Scenario/hosts/ScenarioHostList';
import { ScenarioSnapshot } from './Scenario/snapshot/ScenarioSnapshot';

export const SCENARIO_DEFAULT_TABS: AppRoute[] = [
   { path: '/scenarios/:id', exact: true, name: 'Hosts', component: ScenarioHostList },
   { path: '/scenarios/:id/audit_log', name: 'Audit Log', component: ScenarioAuditLog },
   { path: '/scenarios/:id/details', name: 'Details', component: ScenarioDetails },
   { path: '/scenarios/:id/state', name: 'State', component: ScenarioSnapshot },
];

export const SCENARIO_NOC_TABS: AppRoute[] = [
   { path: '/scenarios/maintenance/switch/:id', exact: true, name: 'Hosts', component: ScenarioHostList },
   { path: '/scenarios/maintenance/switch/:id/audit_log', name: 'Audit Log', component: ScenarioAuditLog },
];

// All tabs for importing in routes.ts
export const SCENARIO_TABS: AppRoute[] = [...SCENARIO_DEFAULT_TABS, ...SCENARIO_NOC_TABS];
