import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Route, RouteComponentProps } from 'react-router';

import {
   fullWidthOutlineDecorator,
   routerDecorator,
   toastsSupportDecorator,
   reduxStoryDecorator,
} from '../../../stories';

import { PlotItem } from './item';

storiesOf('automation-plots|item', module)
   .addDecorator(fullWidthOutlineDecorator)
   .addDecorator(toastsSupportDecorator)
   .addDecorator(routerDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('regular', () => {
      const render = (props: RouteComponentProps<{ id: string }>) => {
         props.match.params.id = 'test';

         return <PlotItem {...(props as any)} />;
      };

      return <Route render={render} />;
   });
