import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Route, RouteComponentProps } from 'react-router';

import { fullWidthOutlineDecorator, routerDecorator, toastsSupportDecorator } from '../../../stories';
import { actionsSupportDecorator } from '../../../stories/decorators/actionsSupportDecorator';

import { IUrlParams, PlotList } from './list';

storiesOf('automation-plots|list', module)
   .addDecorator(fullWidthOutlineDecorator)
   .addDecorator(routerDecorator)
   .addDecorator(toastsSupportDecorator)
   .addDecorator(actionsSupportDecorator)
   .add('regular', () => {
      const render = (props: RouteComponentProps<IUrlParams>) => <PlotList {...props} />;

      return <Route render={render} />;
   });
