import { IResult } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import * as H from 'history';
import * as React from 'react';
import { useCallback } from 'react';
import { Link } from 'react-router-dom';

import { PlotAction, PlotActionButtons } from '../../../actions/automation_plot_actions';
import { IAutomationPlot, ROUTE_LINKS } from '../../../models';
import { OwnersList, useCanEditPlot } from '../../../shared';

import styles from './list_item.module.css';
import { config } from 'services';

interface IProps {
   item: IAutomationPlot;
   location: H.Location;

   onRemoved(id: string): void;
}

export const PlotListItem = React.memo(({ item, onRemoved, location }: IProps) => {
   const { id, name, owners } = item;

   // hooks
   const canEdit = useCanEditPlot(item);

   // handlers
   const remove = useCallback(
      (action: PlotAction, results: IResult[]) => {
         const result = results[0];
         if (!result.success) {
            toasts.apiError('Remove automation plot', result.response);

            return;
         }

         if (action === PlotAction.Remove) {
            onRemoved(id);
         }
      },
      [id, onRemoved],
   );

   // render
   return (
      <tr data-e2e={'PlotListItem'} key={id}>
         <td className={styles.name}>
            <Link to={{ pathname: ROUTE_LINKS.automationPlot(id), state: { prev: location } }}>{name}</Link>
         </td>
         {config.isExternal ? null : (
            <td>
               <OwnersList cls={styles.userList} forceAvatars={true} editable={false} value={owners!} />
            </td>
         )}
         <td>{canEdit ? <PlotActionButtons cls={styles.buttons} context={item} onActionFinished={remove} /> : null}</td>
      </tr>
   );
});

PlotListItem.displayName = 'PlotListItem';
