import { IPureValueProps } from '@yandex-infracloud-ui/libs-next';
import { Checkbox } from '@yandex-data-ui/common';
import * as React from 'react';

import { ICheck } from '../../../models';

import styles from './CheckActions.module.css';

interface IProps extends IPureValueProps<ICheck> {
   readonly: boolean;
}

export const CheckActions = React.memo(({ readonly, value, onChange }: IProps) => {
   // helpers
   const updateValue = (patch: Partial<ICheck>) => {
      const newValue: ICheck = { ...value, ...patch };
      if (newValue.reboot || newValue.redeploy || newValue.profile) {
         newValue.report_failure = true;
         newValue.wait = false;
      }
      onChange(newValue);
   };

   // handlers
   const onRebootChange = () => updateValue({ reboot: !value.reboot });

   const onRedeployChange = () => updateValue({ redeploy: !value.redeploy });

   const onProfileChange = () => updateValue({ profile: !value.profile });

   const onWaitChange = () => updateValue({ wait: !value.wait });

   const onReportFailureChange = () => updateValue({ report_failure: !value.report_failure });

   // render
   return (
      <>
         <Checkbox
            size={'m'}
            content={'Reboot'}
            className={styles.checkbox}
            disabled={readonly}
            checked={value.reboot}
            name={'reboot'}
            onChange={onRebootChange}
         />

         <Checkbox
            size={'m'}
            content={'Redeploy'}
            className={styles.checkbox}
            disabled={readonly}
            checked={value.redeploy}
            name={'redeploy'}
            onChange={onRedeployChange}
         />
         <Checkbox
            size={'m'}
            content={'Profile'}
            className={styles.checkbox}
            disabled={readonly}
            checked={value.profile}
            name={'profile'}
            onChange={onProfileChange}
         />
         <Checkbox
            size={'m'}
            content={'Wait'}
            className={styles.checkbox}
            checked={value.wait}
            name={'wait'}
            onChange={onWaitChange}
            disabled={readonly || value.reboot || value.redeploy || value.profile}
         />
         <Checkbox
            size={'m'}
            content={'Report failure'}
            className={styles.checkbox}
            checked={value.report_failure}
            name={'report_failure'}
            onChange={onReportFailureChange}
            disabled={readonly || value.reboot || value.redeploy || value.profile}
         />
      </>
   );
});

CheckActions.displayName = 'CheckActions';
