import { classNames } from '@yandex-infracloud-ui/libs-next';
import { default as React, ReactNode } from 'react';

import styles from './CheckLayout.module.css';

interface IProps {
   actions: ReactNode;
   buttons: ReactNode;
   cls?: string;
   dragHandle: ReactNode;
   name: ReactNode;
}

export const CheckLayout = ({ cls, actions, buttons, dragHandle, name }: IProps) => {
   return (
      <li className={classNames(styles.row, cls)}>
         {dragHandle}

         <div className={styles.name}>{name}</div>

         <div className={styles.actions}>{actions}</div>

         <div className={styles.buttons}>{buttons}</div>
      </li>
   );
};
