import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { useState } from 'react';

import { ICheck } from '../../../models';
import { CheckList } from './CheckList';

function CheckListStory() {
   const [value, setValue] = useState<ICheck[]>([
      { enabled: true, name: 'test check', reboot: true, redeploy: true, report_failure: true },
      { enabled: true, name: 'test check2', reboot: false, redeploy: true, report_failure: true },
      { enabled: false, name: 'test check3', reboot: false, redeploy: false, report_failure: false },
   ]);

   return <CheckList readonly={boolean('readonly', false)} value={value} onChange={setValue} />;
}

storiesOf('automation-plots|CheckList', module).add('regular', () => <CheckListStory />);
