import { Button, TextInput } from '@yandex-data-ui/common';
import * as React from 'react';

import { ICheck } from '../../../models';
import { CheckActions } from './CheckActions';
import { CheckLayout } from './CheckLayout';
import styles from './NewCheckListItem.module.css';

interface IProps {
   value: ICheck;

   onChange(value: ICheck): void;

   onAdd(): void;
}

export const NewCheckListItem = ({ value, onChange, onAdd }: IProps) => {
   // handlers
   const onNameChange = (name: string | number) => onChange({ ...value, name: String(name) });

   const onEnter = (e: React.KeyboardEvent) => {
      if (e.key === 'Enter') {
         onAdd();
      }
   };

   // render
   const input = (
      <TextInput
         view={'normal'}
         size={'s'}
         className={styles.name}
         placeholder={'Enter plot name'}
         value={value.name}
         onUpdate={onNameChange}
         onKeyDown={onEnter}
      />
   );
   const button = (
      <Button view={'outlined'} size={'m'} onClick={onAdd} className={styles.addBtn}>
         Add
      </Button>
   );

   return (
      <CheckLayout
         cls={styles.row}
         dragHandle={<div />}
         name={input}
         actions={<CheckActions readonly={false} value={value} onChange={onChange} />}
         buttons={button}
      />
   );
};
