import { ModalConfig } from '../../../../shared';

import { TurnOffModal } from './TurnOffModal';
import { TurnOnModal } from './TurnOnModal';

export enum TurnModal {
   Turn = 'turn',
}

export const modalConfigs = new Map<TurnModal, ModalConfig>([
   [
      TurnModal.Turn,
      {
         off: {
            component: TurnOffModal,
            failureMessage: 'Check is turning off',
            successMessage: 'Check has been turned off',
         },
         on: {
            component: TurnOnModal,
            failureMessage: 'Check is turning on',
            successMessage: 'Check has been turned on',
         },
      },
   ],
]);
