import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Route, RouteComponentProps } from 'react-router';

import { fullWidthOutlineDecorator, routerDecorator, toastsSupportDecorator } from '../../../stories';

import { NewPlot } from './new';

storiesOf('automation-plots|new', module)
   .addDecorator(fullWidthOutlineDecorator)
   .addDecorator(toastsSupportDecorator)
   .addDecorator(routerDecorator)
   .add('regular', () => {
      const render = (props: RouteComponentProps) => <NewPlot {...(props as any)} />;

      return <Route render={render} />;
   });
