import { fromQuery, Loader, PageError, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useContext, useMemo } from 'react';
import { RouteComponentProps } from 'react-router';

import { AuditLog, ILogUrlParams, LogLayout } from '../../../rich_shared';
import { HostContext } from '../../../shared';

type Props = RouteComponentProps<ILogUrlParams>;

export const HostAuditLog = React.memo((props: Props) => {
   const value = useContext(HostContext);
   const fqdn = useMemo(() => (value.host ? `${value.host!.name || ''} ${value.host!.inv}` : ''), [value]);
   const { id } = useMemo<ILogUrlParams>(() => fromQuery(props.location.search), [props.location.search]);

   const forceFilters = useMemo(() => (fqdn ? { fqdn } : {}), [fqdn]);
   let layout: LogLayout = 'host';

   if (value.isLoading) {
      return <Loader text={'Host loading'} />;
   }

   if (!value.host) {
      return <PageError text={value.error} />;
   }

   if (id) {
      layout = 'host-single';
   }

   return (
      <>
         <WindowTitle value={`Host ${value.host.name} audit log`} />
         <AuditLog id={id} layout={layout} forceFilters={forceFilters} {...props} />
      </>
   );
});

HostAuditLog.displayName = 'HostAuditLog';
