import { _trimPartLog } from './HostLog';

describe('HostLog', () => {
   it('_trimPartLog', () => {
      // noinspection SpellCheckingInspection
      expect(
         _trimPartLog(`36	Saving installation config to: /mnt/chroot/etc/
2018-06-25T18:14:16.971103	INFO	bffd9027-aaa4-404c-b4f0-ff7d7bbd4b1a	37	Processing private data
`),
      ).toBe(`2018-06-25T18:14:16.971103	INFO	bffd9027-aaa4-404c-b4f0-ff7d7bbd4b1a	37	Processing private data
`);

      // noinspection SpellCheckingInspection
      expect(
         _trimPartLog(`nal stage 'sleep -r 10' (remote)
2018.11.06 18:16:27 | log | Executing 'r:pxe-switch -c' (remote)
2018.11.06 18:16:37 | log | Executing 'r:ipmi-fwup' (remote)`),
      ).toBe(`2018.11.06 18:16:27 | log | Executing 'r:pxe-switch -c' (remote)
2018.11.06 18:16:37 | log | Executing 'r:ipmi-fwup' (remote)`);
   });
});
