import { CopyableText, EMPTY_VALUE, Loader } from '@yandex-infracloud-ui/libs-next';
import * as H from 'history';
import * as React from 'react';
import { Link } from 'react-router-dom';

import { HostMessageSeverity, IHost, ROUTE_LINKS } from '../../../models';
import { HostStatusMessages, TrackerLink, ProjectName, Field } from '../../../shared';

import styles from './HostStatusDetails.module.css';

interface IProps {
   host: IHost | null;
   location: H.Location<any>;
}

export const HostStatusDetails = React.memo(({ host, location }: IProps) => {
   if (!host) {
      return <Loader cls={styles.loader} />;
   }

   const projectLink: H.LocationDescriptorObject = {
      pathname: ROUTE_LINKS.project(host.project),
      state: { prev: location },
   };

   return (
      <div className={styles.details}>
         <div className={styles.column}>
            <Field title={'Project'}>
               {host.project ? (
                  <Link to={projectLink} data-e2e={'project-link'}>
                     <ProjectName id={host.project} />
                  </Link>
               ) : (
                  EMPTY_VALUE
               )}
            </Field>

            <Field title={'Host state'}>{host.state ? host.state : EMPTY_VALUE}</Field>

            {host.operation_state ? <Field title={'Operation state'}>{host.operation_state}</Field> : null}

            <Field title={'Host status'}>
               {host.status ? host.status : EMPTY_VALUE}
               {host.status && host.task ? `:${host.task.status}` : null}
            </Field>

            <Field title={'Inventory №'}>
               <span className={styles.id}>{host.inv}</span>
               <CopyableText text={host.inv.toString()} />
            </Field>

            <Field title={'UUID'}>
               <span className={styles.id}>{host.uuid}</span>
               <CopyableText text={host.uuid.toString()} />
            </Field>
         </div>

         <div className={styles.column}>
            <Field title={'Scenario'}>
               {host.scenario_id ? (
                  <Link to={{ pathname: ROUTE_LINKS.scenario(host.scenario_id), state: { prev: location } }}>
                     {host.scenario_id}
                  </Link>
               ) : (
                  EMPTY_VALUE
               )}
            </Field>

            <Field title={'Ticket'}>{host.ticket ? <TrackerLink ticket={host.ticket} /> : EMPTY_VALUE}</Field>

            <Field title={'Tier'}>{host.tier || EMPTY_VALUE}</Field>

            <Field title={'Type'}>{host.type || EMPTY_VALUE}</Field>

            <Field title={'Messages'}>
               <HostStatusMessages host={host} severity={HostMessageSeverity.Info} />
            </Field>
         </div>
      </div>
   );
});

HostStatusDetails.displayName = 'HostStatusDetails';
