import { Loader, PageError, WindowTitle } from '@yandex-infracloud-ui/libs-next';
import { Card } from '@yandex-data-ui/common';
import * as React from 'react';

import { HostLogType } from '../../../models';
import { HostContext } from '../../../shared';

import { HostLogEnhanced } from '../components/HostLog';

export function HostCoronerLogConsumed() {
   return (
      <HostContext.Consumer>
         {value =>
            value.isLoading ? (
               <Loader text={'Host loading'} />
            ) : (
               <>
                  {value.host ? (
                     <>
                        <div style={{ display: 'flex', marginBottom: '1rem' }}>
                           <Card theme={'warning'}>
                              <div style={{ padding: 10, maxWidth: 650 }}>
                                 <strong>Early access</strong>
                                 <br />
                                 Be aware that alpha versions may be less stable than final version officially released
                                 to the public. You may encounter problems such as app crashes ro features that do not
                                 work properly.
                              </div>
                           </Card>
                        </div>
                        <WindowTitle value={`Host ${value.host.name} coroner log`} />
                        <HostLogEnhanced
                           hostUuid={value.host.uuid}
                           hostName={value.host.name}
                           type={HostLogType.Coroner}
                        />
                     </>
                  ) : (
                     <PageError text={value.error} />
                  )}
               </>
            )
         }
      </HostContext.Consumer>
   );
}
