import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { IHost } from '../../../models';
import { HostContext, IHostContextValue } from '../../../shared';
import { HostHealthTabConsumed } from './HostHealthTab';

const context: IHostContextValue = {
   boxes: null,
   canEdit: false,
   canRunHostAction: false,
   error: '',
   host: ({
      name: 'acab.search.yandex.net',
   } as Partial<IHost>) as IHost,
   isLoading: false,
   onChange: action('onChange'),
};

storiesOf('host|components/HostHealthTab', module).add('regular', () => (
   <HostContext.Provider value={context}>
      <HostHealthTabConsumed />
   </HostContext.Provider>
));
