import { storiesOf } from '@storybook/react';
import { arrayToSet } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { Route } from 'react-router';

import { HostState, IHost, Provisioner } from '../../../models';
import { _fillHostFields } from '../../../services/api/host_api';
import { routerDecorator } from '../../../stories';

import { HostInformation } from './HostInformation';

const host: Partial<IHost> = {
   active_mac: '00:25:90:83:1b:c2',
   active_mac_source: 'agent',
   active_mac_time: 1558609018,
   config: 'web',
   deploy_tags: arrayToSet(['xxx', 'yyy']),
   // health: {
   //    check_statuses: {
   //       meta: HostHealthStatus.Passed,
   //       rack: HostHealthStatus.Passed,
   //       ssh: HostHealthStatus.Passed,
   //       switch: HostHealthStatus.Passed,
   //       unreachable: HostHealthStatus.Passed,
   //    },
   //    status: 'ok',
   // },
   inv: 100061004,
   ipmi_mac: '00:25:90:83:4e:53',
   location: {
      city: 'SAS',
      country: 'RU',
      datacenter: 'SASTA',
      network_source: 'lldp',
      network_timestamp: 1558608898,
      physical_timestamp: 1498068423,
      port: 'ge1/0/10',
      queue: 'SAS-1.3.3',
      rack: '21',
      short_datacenter_name: 'sas',
      short_queue_name: 'sas1.3.3',
      switch: 'sas1-s204',
   },
   macs: ['00:25:90:83:1b:c2', '00:25:90:83:1b:c3'],
   name: 'sas1-2864.search.yandex.net',
   project: 'test',
   provisioner: Provisioner.LUI,
   restrictions: arrayToSet(['automation']),
   state: HostState.Assigned,
   status: 'ready',
   status_audit_log_id: 'e0458c32018e4072a1aafd29ed4c5b4d',
   status_author: 'n-malakhov@',
};

_fillHostFields(host as IHost);

storiesOf('host|information/HostInformation', module)
   .addDecorator(routerDecorator)
   .add('Test host 1', () => <Route render={routeProps => <HostInformation host={host as IHost} {...routeProps} />} />);
