import { classNames } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { PropsWithChildren, ReactNode } from 'react';

import styles from './Field.module.css';

interface IProps {
   customTitle?: ReactNode;
   fullWidth?: boolean;
   title: string;
}

export const Field = ({ customTitle, title, children, fullWidth = false }: PropsWithChildren<IProps>) => (
   <div className={classNames(styles.field, { [styles.fullWidth]: fullWidth })}>
      <div className={styles.title}>{customTitle || title}</div>
      <div className={styles.value}>{children}</div>
   </div>
);

Field.displayName = 'Field';
