import { _stripTags } from './HostBotDetails';

describe('host/information/HostBotDetails', () => {
   const raw = `<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
111858 iva5-y98-49.cloud.yandex.net<br/>Model: XEON5645 HW/RH1285/4T3.5/1U/1P (2*INTEL XEON E5645/12*DDR3ECCREG/4*SATA-3.5)<br/>Desc.: HUAWEI TECAL RH1285(64 GB/BC11BTSA/N/A)<br />MAC: 0819A626E23C,0819A626E23D;0819A626E23E<br/>S/N: 286137-011<br/><br/>
904500 EXPANSIONCARDS\tHP-SC44Ge-416096-B21 (DISKCONTROLLERS) S/N:SP02889461<br>
900566622 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C7CF6<br>
900566784 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C7D6C<br>
900566674 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C7CDE<br>
900566863 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C285F<br>
100383315 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100383326 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100386860 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100390457 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100387350 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100390623 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100389532 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
100389537 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:<br>
`;
   const expected = `111858 iva5-y98-49.cloud.yandex.net
Model: XEON5645 HW/RH1285/4T3.5/1U/1P (2*INTEL XEON E5645/12*DDR3ECCREG/4*SATA-3.5)
Desc.: HUAWEI TECAL RH1285(64 GB/BC11BTSA/N/A)
MAC: 0819A626E23C,0819A626E23D;0819A626E23E
S/N: 286137-011

904500 EXPANSIONCARDS\tHP-SC44Ge-416096-B21 (DISKCONTROLLERS) S/N:SP02889461
900566622 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C7CF6
900566784 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C7D6C
900566674 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C7CDE
900566863 HDD Micron-MTFDDAK800MBB(M500DC) (800GB/SATA/SSD/2.5) S/N:14120C0C285F
100383315 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100383326 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100386860 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100390457 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100387350 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100390623 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100389532 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:
100389537 Оперативная память NANYA 8192MB PC3L-10600R-9-11-B0 2RX S/N:`;

   it('stripTags', () => {
      expect(_stripTags(raw)).toBe(expected);
   });
});
