import { Loader, Rows, useDismounted } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useEffect, useState } from 'react';
import { map, takeUntil } from 'rxjs/operators';

import { hostApi } from '../../../../services';
import styles from './HostBotDetails.module.css';

interface IProps {
   inv: number; // Менять на UUID не требуется, BOT оперирует inv
}

export function _stripTags(html: string): string {
   return html
      .replace(/<meta.+?>/, '')
      .replace(/<br[\s]?[/]?>\n/g, '\n')
      .replace(/<br[\s]?[/]?>/g, '\n')
      .trim();
}

export const HostBotDetails = React.memo(({ inv }: IProps) => {
   // hooks
   const dismounted = useDismounted();
   const [configuration, setConfiguration] = useState('');

   // effects
   useEffect(() => {
      hostApi
         .getBotConfiguration(inv)
         .pipe(map(_stripTags), takeUntil(dismounted))
         .subscribe(setConfiguration, toasts.handleApiError('Bot configuration loading'));
   }, [dismounted, inv]);

   // render
   return configuration ? (
      <div className={styles.details}>
         <Rows text={configuration} />
      </div>
   ) : (
      <Loader />
   );
});

HostBotDetails.displayName = 'HostBotDetails';
