import { EMPTY_VALUE, formatDate, isEmpty } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { IHost } from '../../../../models';

import styles from './HostConfigurationDetails.module.css';
import { Field } from './Field';
import { IpAddressList } from './IpAddressList';
import { MacAddressList } from './MacAddressList';

interface IProps {
   host: IHost;
}

export const HostConfigurationDetails = React.memo(({ host }: IProps) => {
   return (
      <div className={styles.details}>
         <Field title={'IPMI MAC-address'}>
            {host.ipmi_mac ? <MacAddressList item={host.ipmi_mac} /> : EMPTY_VALUE}
         </Field>

         <Field title={'Network MAC addresses'}>{host.macs ? <MacAddressList list={host.macs} /> : EMPTY_VALUE}</Field>

         <Field title={'Active MAC address'}>
            {host.active_mac ? <MacAddressList item={host.active_mac} /> : EMPTY_VALUE}
         </Field>

         <Field title={'Update time'}>
            {host.active_mac_time ? formatDate(host.active_mac_time as Date) : EMPTY_VALUE}
         </Field>

         <Field title={'MAC source'}>{host.active_mac_source ? host.active_mac_source : EMPTY_VALUE}</Field>

         <Field title={'IP addresses'}>{!isEmpty(host.ips) ? <IpAddressList list={host.ips} /> : EMPTY_VALUE}</Field>
      </div>
   );
});

HostConfigurationDetails.displayName = 'HostConfigurationDetails';
