import { EMPTY_VALUE, Hint, isEmpty, styleHelpers } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useMemo } from 'react';

import { DefaultDeployNetwork, DeployNetwork, EXTERNAL_LINKS, Provisioner } from '../../../../models';
import { TagList, useConstants } from '../../../../shared';
import { Field } from './Field';

import classes from './HostDeployDetails.module.css';

interface IProps {
   config: string;
   deploy_config_policy?: string;
   network?: DeployNetwork;
   provisioner: Provisioner;
   tags?: Set<string> | undefined;
}

export const HostDeployDetails = React.memo(
   ({ provisioner, config, deploy_config_policy, network = DefaultDeployNetwork, tags = new Set() }: IProps) => {
      const { constants } = useConstants();

      const configPolicyHint = useMemo(
         () => constants?.deploy_config_policies.find(p => p.name === deploy_config_policy)?.description ?? null,
         [constants, deploy_config_policy],
      );

      return (
         <>
            <Field title={'Deploy config'}>
               {config ? (
                  <a
                     href={EXTERNAL_LINKS.deployConfig(provisioner, config)}
                     className={styleHelpers.externalLink}
                     target={'_blank'}
                     rel={'noopener noreferrer'}
                  >
                     {config}
                  </a>
               ) : (
                  EMPTY_VALUE
               )}
            </Field>

            <Field title={'Provisioner'}>{provisioner ?? EMPTY_VALUE}</Field>

            <Field title={'Deploy config policy'}>
               {deploy_config_policy ? (
                  <>
                     {deploy_config_policy}
                     {configPolicyHint ? <Hint className={classes.hint} text={configPolicyHint} /> : null}
                  </>
               ) : (
                  EMPTY_VALUE
               )}
            </Field>

            {provisioner === Provisioner.LUI ? <Field title={'Deploy network'}>{network ?? EMPTY_VALUE}</Field> : null}

            {provisioner === Provisioner.EINE ? (
               <Field title={'Deploy tags'}>
                  {isEmpty(tags) ? EMPTY_VALUE : <TagList cls={classes.tags} editable={false} value={tags} />}
               </Field>
            ) : null}
         </>
      );
   },
);

HostDeployDetails.displayName = 'HostDeployDetails';
