import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { HealthStatus, HostHealthStatus, IHostHealth } from '../../../../models';
import { routerDecorator } from '../../../../stories';

import { HostHealthDetails } from './HostHealthDetails';

const health: IHostHealth = {
   check_statuses: {
      bmc: HostHealthStatus.Passed,
      cpu: HostHealthStatus.Passed,
      cpu_capping: HostHealthStatus.Passed,
      disk: HostHealthStatus.Passed,
      fs_check: HostHealthStatus.Passed,
      link: HostHealthStatus.Passed,
      memory: HostHealthStatus.Passed,
      net64_check: HostHealthStatus.Passed,
      overheat: HostHealthStatus.Passed,
      rack: HostHealthStatus.Invalid,
      reboots: HostHealthStatus.Passed,
      ssh: HostHealthStatus.Passed,
      switch: HostHealthStatus.Passed,
      tainted_kernel: HostHealthStatus.Passed,
      unreachable: HostHealthStatus.Passed,
      walle_host_certificate: HostHealthStatus.Passed,
      walle_meta: HostHealthStatus.Passed,
   },
   status: HealthStatus.Ok,
};

storiesOf('host|information/HostHealthDetails', module)
   .addDecorator(routerDecorator)
   .add('regular', () => <HostHealthDetails fqdn={'xxx.yandex.net'} health={health} />);
