import { Loader } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useEffect, useState } from 'react';
import { Link } from 'react-router-dom';

import { IHostHealth, ROUTE_LINKS } from '../../../../models';
import { groupByType, HealthCheckList, IHostHealthGroup, useConstants } from '../../../../shared';

import { Field } from './Field';

interface IProps {
   fqdn: string;
   health: IHostHealth;
}

export const HostHealthDetails = React.memo(({ fqdn, health }: IProps) => {
   // hooks
   const { constants } = useConstants();
   const [groups, setGroups] = useState<IHostHealthGroup[]>([]);

   // effects
   useEffect(() => {
      if (constants) {
         setGroups(groupByType(health.check_statuses, constants.health_check_groups));
      }
   }, [constants, health.check_statuses]);

   // render
   if (groups.length === 0) {
      return <Loader />;
   }

   return (
      <>
         {groups.map(group => (
            <Field key={group.name} title={group.name}>
               <HealthCheckList items={group.items} inline={true} />
            </Field>
         ))}

         <Link to={ROUTE_LINKS.hostHealth(fqdn)}>Show details</Link>
      </>
   );
});

HostHealthDetails.displayName = 'HostHealthDetails';
