import { EMPTY_VALUE, formatDate } from '@yandex-infracloud-ui/libs-next';
import React from 'react';

import { IHostStateExpire } from '../../../../models';
import { TrackerLink, UserOrSystemName } from '../../../../shared';

import { Field } from './Field';

interface Props {
   value: IHostStateExpire;
}

export const HostMaintenanceDetails: React.FC<Props> = React.memo(({ value }) => {
   return (
      <>
         <Field title={'Issuer'}>
            <UserOrSystemName value={value.issuer} />
         </Field>

         <Field title={'Status'}>{value.status}</Field>

         <Field title={'Ticket'}>
            <TrackerLink ticket={value.ticket} />
         </Field>

         <Field title={'Time'}>{value.time ? formatDate(new Date(value.time * 1000)) : EMPTY_VALUE}</Field>
      </>
   );
});

HostMaintenanceDetails.displayName = 'HostMaintenanceDetails';
