import * as React from 'react';
import classes from './IpAddressList.module.css';

interface IProps {
   list: string[];
}

export const IpAddressList = React.memo(({ list }: IProps) => {
   return (
      <>
         {list.map(ip => (
            <div key={ip} className={classes.ipAddress}>
               {ip}
            </div>
         ))}
      </>
   );
});

IpAddressList.displayName = 'IpAddressList';
