import { autobind, classNames } from '@yandex-infracloud-ui/libs-next';
import { ArrowToggle, Button, Popup } from '@yandex-data-ui/common';
import * as React from 'react';

import { MacAddress } from '../../../../models';

import styles from './MacAddressItem.module.css';
import { MacAddressPopup } from './MacAddressPopup';

interface IProps {
   value: MacAddress;
}

interface IState {
   opened: boolean;
}

export class MacAddressItem extends React.PureComponent<IProps, IState> {
   public static defaultProps = {};

   public static propTypes = {};

   private _switcherRef = React.createRef<HTMLButtonElement | HTMLAnchorElement>();

   constructor(props: IProps) {
      super(props);

      this.state = {
         opened: false,
      };
   }

   public render() {
      return (
         <div
            className={classNames(
               {
                  [styles.opened]: this.state.opened,
               },
               styles.macAddress,
            )}
         >
            {this.props.value}
            <Button
               view={'clear'}
               size={'s'}
               className={styles.switcher}
               ref={this._switcherRef}
               onClick={this._onButtonClick}
            >
               <ArrowToggle direction={this.state.opened ? 'top' : 'bottom'} size={18} />
            </Button>
            <Popup
               onOutsideClick={this._onOutsideClick}
               open={this.state.opened}
               anchorRef={this._switcherRef}
               placement={'bottom-end'}
            >
               {this.state.opened ? <MacAddressPopup value={this.props.value} /> : null}
            </Popup>
         </div>
      );
   }

   @autobind
   private _onButtonClick() {
      this.setState({ opened: !this.state.opened });
   }

   @autobind
   private _onOutsideClick() {
      this.setState({ opened: false });
   }
}
